{
 Author:       Craig Ward
 Copyright:    <>

 Date:         17/5/96

 Version:      1.0

 Overview:     Main window for screen saver.

 Notes:        The random() function is used in order to randomly select
               messages or graphics from the EXTENDED.RES file. Note the
               constant "constRan" which sets the highest (less one) value
               from the program will select a random number.
*******************************************************************************}
unit Scrn;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Marquee, StdCtrls, iniFiles, fileCtrl;

type
  TScrnSaveForm = class(TForm)
    imagHeader: TImage;
    pnBorder: TPanel;
    imagSlide: TImage;
    timerMessage: TTimer;
    timerSlide: TTimer;
    lblMessage: TLabel;
    fileBox: TFileListBox;
    procedure FormCreate(Sender: TObject);
    procedure imagSlideMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imagSlideMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure imagSlideClick(Sender: TObject);
    procedure imagSlideDblClick(Sender: TObject);
    procedure imagSlideMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure timerSlideTimer(Sender: TObject);
    procedure timerMessageTimer(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
    FLineHi: longint;
    FLineX: longint;
    FWidth: longint;
    FBmp: TBitmap;
    FLineXR: longint;
    FScroll: TStringList;
    FBmpList: TStringList;
    FKey: string[1];
    function mPasswordOK: boolean;
    procedure mEndShow;
    procedure mCallEnd;
    procedure mPaintLine;
    procedure mScrollText;
    procedure mBmpList;
    procedure mPaintBMP;
    procedure mAnimateSlides;
    procedure mAnimateText;
  public
    { Public declarations }
    FCurPos: TPoint;
    procedure WMSysCommand(var msg: TWMSYSCOMMAND); message WM_SYSCOMMAND;
  end;

var
  ScrnSaveForm: TScrnSaveForm;
  liX,liY: longint;
  wRanBMP,wRanScroll: word;


implementation

{$R *.DFM}

uses
 cw_apps,conini,enter;

{***animation routine***********************************************************}

{paint new bmp}
procedure TScrnSaveForm.mPaintBmp;
var
 w: word;
 pWin,pBuf: pChar;
 r: TRect;
begin

 {load pic}
 with r do
  begin
   left := 0;
   top := 0;
   right := liX;
   bottom := liY;
  end;
 {don't draw rect until new bitmap loaded}
 ValidateRect(canvas.handle,@r);
 try
  w := random(wRanBmp);
  imagSlide.picture.LoadFromFile(FBmpList.strings[w]);
  pnBorder.width := imagSlide.picture.bitmap.width + (2 * pnBorder.bevelWidth);
  pnBorder.height := imagSlide.picture.bitmap.height + (2 * pnBorder.bevelWidth);
  pnBorder.left := (liX - pnBorder.width) div 2; {centre panel, horiz.}
  pnBorder.top := (liY - pnBorder.height) div 2; {centre panel, vert.}
 finally
  InvalidateRect(canvas.handle,@r,false);
 end;

 {save pic}
 if bWallPaperOn then
  begin
   {store windows directory}
   pWin := StrAlloc(fsWinBuffer);
   GetWindowsDirectory(pWin,fsWinBuffer - 1);
   {save pic - TImage's own method comes in handy!}
   imagSlide.picture.SaveToFile( StrPAS(pWin) +'\delphiss.bmp' );
   {update Windows}
   pBuf := StrAlloc(fsMaxFileNameExt);
   try
    StrPCopy(pBuf,'delphiss.bmp');
    SystemParametersInfo(SPI_SETDESKWALLPAPER,0,pBuf,SPIF_UPDATEINIFILE);
   finally
    StrDispose(pBuf);
    StrDispose(pWin);
   end;
  end;

end;

{change slides}
procedure TScrnSaveForm.mAnimateSlides;
begin
 mPaintBmp;
end;

{paint line to canvas}
procedure TScrnSaveForm.mPaintLine;
var
 r: TRect;
 pBuf: pChar;
begin
 pBuf := StrAlloc(length(lblMessage.caption)+1);
 try
  {set rectangle}
   with r do
    begin
     top := 0;
     left := 0;
     bottom := FLineHi;
     right := lblMessage.width;
    end;
   {set memory bitmap}
   with FBmp do
    begin
     width := liX + lblMessage.width;
     height := lblMessage.height;
     with canvas do
      begin
       canvas.brush.color := color;
       canvas.font := lblMessage.font;
       canvas.fillRect(r);
       fbmp.canvas.brush.style := bsClear;
      end;
    end;
   StrPCopy(pBuf,lblMessage.caption);
   {draw text onto memory bitmap}
   if DrawText(FBmp.canvas.handle,pBuf,StrLen(pBuf),r,dt_top) > 0 then
    {copy memory bitmap to form's canvas}
    BitBlt(canvas.handle,FLineX,liY - round(FLineHi * 1.5),r.right,r.bottom,FBmp.canvas.handle,0,0,srcCopy);
 finally
  StrDispose(pBuf);
 end;
end;

{scroll text across screen}
procedure TScrnSaveForm.mAnimateText;
var
 w: word;
 pBuf: pChar;
begin
 if MaxAvail < sizeOf(string) then
  messageDlg('Memory resources too low!',mtWarning,[mbOK],0)
 else
  begin
   pBuf := StrAlloc(sizeOf(string));
   try
    {check to see if right-side of label has gone off screen}
    if FLineXR > 0  then
     begin {scroll text}
      mPaintLine;
      dec(FLineX,(FWidth div 5)); {decrease position - fairly slowly!}
      dec(FLineXR,(FWidth div 5));
     end
    else
     begin {set new label}
      w := random(wRanScroll);
      lblMessage.caption := copy( FScroll.strings[w],1,pos('=',FScroll.strings[w])-1) +' ';
      FLineXR := liX + lblMessage.width; {reset right boundary}
      FLineX := liX; {reset decrement position}
      mPaintLine;
     end;
   finally
    StrDispose(pBuf);
   end;
 end;
end;

{***password encryption*********************************************************}

{check if password-dialog is already loaded (note: implemented due to a looping
 problem).}
procedure TScrnSaveForm.mEndShow;
begin
 if PassEnterDlg = nil then
  mCallEnd
 else
  if not PassEnterDlg.handleAllocated then
   mCallEnd;
end;

{call password dialog}
procedure TScrnSaveForm.mCallEnd;
begin
 ShowCursor(true); {reveal cursor}
 if mPasswordOK then
  close
 else
  {bad return from function, since could be a cancel hide cursor again}
  ShowCursor(false);
end;

{check password}
function TScrnSaveForm.mPasswordOK: boolean;
begin
 result := false; {default}
 if not bPasswordOn then
  result := true {password not enabled, so allow close}
 else
  begin
   {get\check password}
   PassEnterDlg := TPassEnterDlg.create(application);
   try
    {if key press, the use as first letter in edit-box}
    if FKey <> '' then
     begin
      PassEnterDlg.edit1.text := FKey;
      PassEnterDlg.edit1.selStart := 1; {move to end of text}
      FKey := '';
     end;
    {show dialog}
    if PassEnterDlg.showModal = mrOK then
     begin
      {note use of encryption routine - see conini.pas}
      if CompareText(sPasswordText,mEncrypt(PassEnterDlg.edit1.text)) = 0 then
       result := true
      else
       begin {wrong password}
        messageDlg('Incorrect password!',mtWarning,[mbOK],0);
       end;
     end;
   finally
    PassEnterDlg.free;
   end;
  end;
end;

{***messages********************************************************************}

{system commands}
procedure TScrnSaveForm.WMSysCommand(var msg: TWMSYSCOMMAND);
begin
 {do nothing...
  technically, in the case of the screen-saver being password protected, this
  function is superfluours since all key\mouse messages would be caught by the
  form's handlers. However, just in case, this proc will disable the user from
  being able to call the TaskManager, or even switch to another window.}
end;

{on message, end the show}
procedure TScrnSaveForm.FormMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 mEndShow;
end;

{on message, end the show}
procedure TScrnSaveForm.FormMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var
 CurPos: TPoint;
begin
 {check mouse position - if different from one saved, then close}
 GetCursorPos(CurPos);
 if (FCurPos.x <> CurPos.x)  or (FCurPos.y <> CurPos.y) then
  mEndShow;
end;

{on message, end the show}
procedure TScrnSaveForm.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 mEndShow;
end;

{on message, end show}
procedure TScrnSaveForm.imagSlideMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 mEndShow;
end;

{on message, end show}
procedure TScrnSaveForm.imagSlideMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var
 CurPos: TPoint;
begin
 {check mouse position - if different from one saved, then close}
 GetCursorPos(CurPos);
 if (FCurPos.x <> CurPos.x)  or (FCurPos.y <> CurPos.y) then
  mEndShow;
end;

{on message, end show}
procedure TScrnSaveForm.imagSlideClick(Sender: TObject);
begin
 mEndShow;
end;

{on message, end show}
procedure TScrnSaveForm.imagSlideDblClick(Sender: TObject);
begin
 mEndShow;
end;

{on message, end show}
procedure TScrnSaveForm.imagSlideMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 mEndShow;
end;

{on message, end show}
procedure TScrnSaveForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 FKey := chr(key);
 mEndShow;
end;

{on message, end show}
procedure TScrnSaveForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
 mEndShow;
end;

{on message, end show}
procedure TScrnSaveForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 mEndShow;
end;

{***form's preferences*********************************************************}


{on close}
procedure TScrnSaveForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
 FBmp.free;
 FBmpList.free;
 FScroll.free;
end;


{on create}
procedure TScrnSaveForm.FormCreate(Sender: TObject);
var
 metrics: TTextMetric;
 w: word;
 hDC: THandle;
 iP, iC: integer;
begin

 {find number of colours in display - if less than 255 then exit}
 hDC := CreateDC('DISPLAY',nil,nil,nil);
 try
  iP := GetDeviceCaps(hDC, Planes);
  iC := GetDeviceCaps(hDC, BitsPixel);
  if ( iP * iC ) >= 8 then {2^8 is 256}
   {..okay...minimum for the screen saver...}
  else
   begin
    messageDlg('The display is not configured for 256 colours, or more.'+#13#10+
               'This is the minimum for the screen-saver to run under.',mtWarning,[mbOK],0);
    DeleteDC(hDC);
    application.terminate;
   end;
 finally
  DeleteDC(hDC);
 end;

 {allocate resources}
 FBmp := TBitmap.create;
 FBmpList := TStringList.create;
 FScroll := TStringList.create;

 mReadIni; {initiate routine for retrieving password information}

 GetCursorPos(FCurPos); {store cursor position}
 ShowCursor(false); {turn off cursor}

 randomize;

 {store environment settings}
 liX := GetSystemMetrics(SM_CXSCREEN); {width}
 liY := GetSystemMetrics(SM_CYSCREEN); {height}
 canvas.font.assign(lblMessage.font);
 if GetTextMetrics(canvas.handle,metrics) then
  begin
   FWidth := metrics.tmAveCharWidth; {average width of font}
   FLineHi := metrics.tmHeight + metrics.tmInternalLeading; {height of font}
  end;
 FLineX := liX; {will store current x position of scrolling text}

 {set initial bitmap - load from resource}
 mBmpList;
 wRanBmp := FBmpList.count; {set max value to for random parameter}
 if FBmpList.count > 0 then mPaintBMP;

 {set initial message}
 mScrollText;
 wRanScroll := FScroll.count;
 w := random(wRanScroll); {set max value to for random parameter}
 if FScroll.count > 0 then
  lblMessage.caption := copy( FScroll.strings[w],1,pos('=',FScroll.strings[w])-1) +' ';

 FLineXR := liX + lblMessage.width; {store the screen width, plus message width}

 {position items}
 imagHeader.left := (liX - imagHeader.width) div 2; {centre image, horiz.}

 {color}
 self.color := clSilver;

 {timers}
 timerSlide.interval := wChangePic * 1000; {set interval for changing picture}

end;

{**timers**********************************************************************}

{change picture}
procedure TScrnSaveForm.timerSlideTimer(Sender: TObject);
begin
 if FBmpList.count > 0 then mAnimateSlides;
end;

{scroll text}
procedure TScrnSaveForm.timerMessageTimer(Sender: TObject);
begin
 if bScrollTextOn then
  if FScroll.count > 0 then mAnimateText;
end;


{***ini*************************************************************************}

{store scrolling text}
procedure TScrnSaveForm.mScrollText;
var
 inf: TIniFile;
begin
 inf := TIniFile.create(ExtractFilePath(paramStr(0))+'delphiss.ini');
 try
  inf.ReadSectionValues('SCROLL',FScroll);
 finally
  inf.free;
 end;
end;

{store bmps}
procedure TScrnSaveForm.mBmpList;
var
 inf: TIniFile;
 tmpList: TStringList;
 iInc,iFile: integer;
begin
 inf := TIniFile.create(ExtractFilePath(paramStr(0))+'delphiss.ini');
 tmpList := TStringList.create;
 try
  inf.ReadSectionValues('COLLECTIONS',tmpList);
  {iterate through installed collections}
  for iInc := 0 to (tmpList.count -1) do
   begin

    {check if user does not want to select from all collections}
    if not bUseAll then
     if CompareText(sCollection,
                    copy(tmpList.strings[iInc],pos('=',tmpList.strings[iInc])+1,gintMaxCollName)) = 0
      then continue;

    {set file-list box}
    fileBox.mask := '*.bmp'; {filter on bitmaps}
    fileBox.directory := copy( tmpList.strings[iInc],1,pos('=',tmpList.strings[iInc])-1) +' ';
    {iterate through files, in each installed collection}
    for iFile := 0 to (fileBox.items.count -1) do
     begin
      {add files to file-list}
      FBmpList.add( ExpandFileName(fileBox.items[iFile]) );
     end;
   end;

 finally
  inf.free;
  tmpList.free;
 end;
end;


{}
end.

